/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef SPICE3_LIST_API_
#define SPICE3_LIST_API_

#include "rlTypes.h"

struct rltbTraceBufferConfig_Struct;

RL_C_API rlCommandListHandle rlListAllocate(rlHandle handle);
RL_C_API rlCommandListHandle rlListAllocateFromString(rlHandle handle, const char* commandList);

RL_C_API rlResult rlListReleaseHandle(rlCommandListHandle handle);

RL_C_API rlResult rlListSet(rlHandle handle, int32_t listID, rlCommandListHandle list, bool append, int executionLimit);
RL_C_API rlResult rlListGet(rlHandle handle, int32_t listID, rlCommandListHandle list);
RL_C_API rlResult rlListLoad(rlHandle handle, int32_t listID);
RL_C_API rlResult rlListStore(rlHandle handle, int32_t listID);

RL_C_API rlResult rlListExecute(rlHandle handle, int32_t listID);
RL_C_API rlResult rlListDelete(rlHandle handle, int32_t listID, bool fromDisk);

RL_C_API rlResult rlListResetExecution(rlHandle handle);
RL_C_API rlResult rlListAbortExecution(rlHandle handle);
RL_C_API rlResult rlListGetListStatus(rlHandle handle, int32_t listId, rlListStatus* listStatus);
RL_C_API rlResult rlListIsExecutionInProgress(rlHandle handle, bool* inProgress);

RL_C_API rlResult rlListGetListCaret(rlHandle handle, int32_t listId, int32_t* caret);
RL_C_API rlResult rlListGetStoredListIDs(rlHandle handle, uint32_t* outBuffer, uint32_t bufferLen, uint32_t* outLen);

RL_C_API rlResult rlListClearPendingEvents(rlHandle handle);
RL_C_API rlResult rlListWaitForListIdle(rlHandle handle, int32_t timeoutMs, bool* successBeforeTimeout, int32_t* listId);
RL_C_API rlResult rlListWaitForListDone(rlHandle handle, int32_t timeoutMs, bool* successBeforeTimeout, int32_t* listId);
RL_C_API rlResult rlListWaitForProgress(rlHandle handle, int32_t timeoutMs, bool* successBeforeTimeout, int32_t* progressId);

RL_C_API rlResult rlListInterruptWaitForListIdle(rlHandle handle);
RL_C_API rlResult rlListInterruptWaitForListDone(rlHandle handle);
RL_C_API rlResult rlListInterruptWaitForProgress(rlHandle handle);

RL_C_API rlCallbackHandle rlListRegisterListIdleCallback(rlHandle handle, rlListIdleCallback func);
RL_C_API rlResult rlListUnRegisterListIdleCallback(rlCallbackHandle handle);
RL_C_API rlCallbackHandle rlListRegisterListDoneCallback(rlHandle handle, rlListDoneCallback func);
RL_C_API rlResult rlListUnRegisterListDoneCallback(rlCallbackHandle handle);
RL_C_API rlCallbackHandle rlListRegisterProgressCallback(rlHandle handle, rlProgressCallback func);
RL_C_API rlResult rlListUnRegisterProgressCallback(rlCallbackHandle handle);
RL_C_API rlCallbackHandle rlListRegisterErrorEventCallback(rlHandle handle, rlErrorCallback func);
RL_C_API rlResult rlListUnRegisterErrorEventCallback(rlCallbackHandle handle);

RL_C_API rlResult rlListAppendCommandFromString(rlCommandListHandle handle, const char* command);

RL_C_API rlResult rlListAppendList(rlCommandListHandle handle, rlCommandListHandle other);
RL_C_API rlResult rlListStringLen(rlCommandListHandle handle, uint32_t* stringLength);
RL_C_API rlResult rlListToString(rlCommandListHandle handle, char* buffer, uint32_t bufferSize, uint32_t* stringLength);
RL_C_API rlResult rlListCommandCount(rlCommandListHandle handle, uint32_t* count);

RL_C_API rlResult rlListClear(rlCommandListHandle handle);

RL_C_API rlResult rlListSetExecutionLimit(rlCommandListHandle handle, int executionLimit);
RL_C_API rlResult rlListGetExecutionLimit(rlCommandListHandle handle, int* limit);

RL_C_API rlResult rlListGetLastExecutionStats(rlHandle handle, rlListExecutionStats* outStats);

RL_C_API rlResult rlListAppendLmFrequency(rlCommandListHandle handle, double frequency);
RL_C_API rlResult rlListAppendLmWidth(rlCommandListHandle handle, double width);
RL_C_API rlResult rlListAppendSpeedScale(rlCommandListHandle handle, double factor);
RL_C_API rlResult rlListAppendPowerScale(rlCommandListHandle handle, double factor, rlPowerChannels powerTargetChannel);
RL_C_API rlResult rlListAppendJumpSpeed(rlCommandListHandle handle, double speed);
RL_C_API rlResult rlListAppendMarkSpeed(rlCommandListHandle handle, double speed);
RL_C_API rlResult rlListAppendMagnificationSpeed(rlCommandListHandle handle, double speed);
RL_C_API rlResult rlListAppendJumpDelay(rlCommandListHandle handle, double delay);
RL_C_API rlResult rlListAppendEnableVariableJumpDelay(rlCommandListHandle handle, bool enable);
RL_C_API rlResult rlListAppendMinJumpDelay(rlCommandListHandle handle, double delay);
RL_C_API rlResult rlListAppendJumpLengthLimit(rlCommandListHandle handle, double length);
RL_C_API rlResult rlListAppendMarkDelay(rlCommandListHandle handle, double delay);
RL_C_API rlResult rlListAppendPolyDelay(rlCommandListHandle handle, double delay);
RL_C_API rlResult rlListAppendEnableVariablePolyDelay(rlCommandListHandle handle, bool enable);
RL_C_API rlResult rlListAppendLaserOnDelay(rlCommandListHandle handle, double delay);
RL_C_API rlResult rlListAppendLaserOffDelay(rlCommandListHandle handle, double delay);

RL_C_API rlResult rlListAppendEvaluationLeadTime(rlCommandListHandle handle, double time);

RL_C_API rlResult rlListAppendIncrementCounter(rlCommandListHandle handle, const char* counterName);
RL_C_API rlResult rlListAppendBooleanSet(rlCommandListHandle handle, const char* variableName, bool value);
RL_C_API rlResult rlListAppendIntegerSet(rlCommandListHandle handle, const char* variableName, int32_t value);

RL_C_API rlResult rlListAppendSignalSet(rlCommandListHandle handle, const char* signaleName);
RL_C_API rlResult rlListAppendSignalReset(rlCommandListHandle handle, const char* signaleName);

RL_C_API rlResult rlListAppendProgress(rlCommandListHandle handle, uint32_t id);

RL_C_API rlResult rlListAppendEnablePilot(rlCommandListHandle handle, bool enable);
RL_C_API rlResult rlListAppendArmLaser(rlCommandListHandle handle, bool enable);
RL_C_API rlResult rlListAppendEnableVelocityCorrection(rlCommandListHandle handle, bool enable, rlPowerChannels powerTargetChannel);
RL_C_API rlResult rlListAppendEnablePowerCorrection(rlCommandListHandle handle, bool enable, rlPowerChannels powerTargetChannel);
RL_C_API rlResult rlListAppendEnablePowerCalibration(rlCommandListHandle handle, bool enable, rlPowerChannels powerTargetChannel);

RL_C_API rlResult rlListAppendLaserOn2(rlCommandListHandle handle, int32_t pulses, bool async);
RL_C_API rlResult rlListAppendLaserOn(rlCommandListHandle handle);

RL_C_API rlResult rlListAppendLaserOff(rlCommandListHandle handle);
RL_C_API rlResult rlListAppendPower(rlCommandListHandle handle, uint16_t power, rlPowerChannels powerTargetChannel);
RL_C_API rlResult rlListAppendPower2(rlCommandListHandle handle, uint16_t power, double powerChangeRate, rlPowerChannels powerTargetChannel);
RL_C_API rlResult rlListAppendSimmerPower(rlCommandListHandle handle, uint16_t power);

RL_C_API rlResult rlListAppendEnableDashedLine(rlCommandListHandle handle, bool enable, double start);
RL_C_API rlResult rlListAppendDashedLinePattern(rlCommandListHandle handle, const double* onOffPattern, uint32_t onOffPatternLength);

RL_C_API rlResult rlListAppendScalingFactor(rlCommandListHandle handle, double x, double y);
RL_C_API rlResult rlListAppendTransformation(rlCommandListHandle handle, const rlTransform3D* transformation);
RL_C_API rlResult rlListAppendHeadingScale(rlCommandListHandle handle, double x, double y, double z);

RL_C_API rlResult rlListAppendWaitStart(rlCommandListHandle handle, int32_t timeout);
RL_C_API rlResult rlListAppendWaitForInput(
    rlCommandListHandle handle, uint32_t cond, rlIOPort port, bool compareCondAsMask, bool ifNotTrue, uint32_t mask, int32_t timeout);

RL_C_API rlResult rlListAppendWaitForSignal(rlCommandListHandle handle, const char* signaleName, int32_t timeout);
RL_C_API rlResult rlListAppendSuspend(rlCommandListHandle handle);

RL_C_API rlResult rlListAppendStartMotf(rlCommandListHandle handle);
RL_C_API rlResult rlListAppendStopMotf2D(rlCommandListHandle handle, double x, double y);
RL_C_API rlResult rlListAppendStopMotf3D(rlCommandListHandle handle, double x, double y, double z);
RL_C_API rlResult rlListAppendMotfWaitPart(rlCommandListHandle handle, int32_t timeout);
RL_C_API rlResult rlListAppendMotfWaitDistance(rlCommandListHandle handle, double distance, rlMotfDistanceMode mode, int32_t timeout);
RL_C_API rlResult rlListAppendMotfTileOffset(rlCommandListHandle handle, double tileOffset);

RL_C_API rlResult rlListAppendSleep(rlCommandListHandle handle, double delay);

RL_C_API rlResult rlListAppendSkyWritingMode(rlCommandListHandle handle, rlSkyWritingMode mode);
RL_C_API rlResult rlListAppendSkyWritingMinCoH(rlCommandListHandle handle, double minCoH);
RL_C_API rlResult rlListAppendSkyWritingMergedExtensionsMaxCoH(rlCommandListHandle handle, double maxCoH);
RL_C_API rlResult rlListAppendSkyWritingAccelerationDelay(rlCommandListHandle handle, double accelerationDelay);
RL_C_API rlResult rlListAppendSkyWritingDecelerationDelay(rlCommandListHandle handle, double decelerationDelay);
RL_C_API rlResult rlListAppendSkyWritingExtensionTime(rlCommandListHandle handle, double extensionTime);
RL_C_API rlResult rlListAppendSkyWritingLaserOnDelay(rlCommandListHandle handle, double laserOnDelay);
RL_C_API rlResult rlListAppendSkyWritingLaserOffDelay(rlCommandListHandle handle, double laserOffDelay);

RL_C_API rlResult rlListAppendJumpAbs2D(rlCommandListHandle handle, double x, double y);
RL_C_API rlResult rlListAppendJumpRel2D(rlCommandListHandle handle, double x, double y);
RL_C_API rlResult rlListAppendJumpAbs3D(rlCommandListHandle handle, double x, double y, double z);
RL_C_API rlResult rlListAppendJumpRel3D(rlCommandListHandle handle, double x, double y, double z);
RL_C_API rlResult rlListAppendMarkAbs2D(rlCommandListHandle handle, double x, double y);
RL_C_API rlResult rlListAppendMarkRel2D(rlCommandListHandle handle, double x, double y);
RL_C_API rlResult rlListAppendMarkAbs3D(rlCommandListHandle handle, double x, double y, double z);
RL_C_API rlResult rlListAppendMarkRel3D(rlCommandListHandle handle, double x, double y, double z);

RL_C_API rlResult rlListAppendMagnificationAbs(rlCommandListHandle handle, double magnification, bool async);
RL_C_API rlResult rlListAppendMagnificationRel(rlCommandListHandle handle, double magnification, bool async);

RL_C_API rlResult rlListAppendLabel(rlCommandListHandle handle, const char* label);

RL_C_API rlResult rlListAppendBranchAbs(rlCommandListHandle handle, int32_t pos);
RL_C_API rlResult rlListAppendBranchRel(rlCommandListHandle handle, int32_t pos);
RL_C_API rlResult rlListAppendBranchToLabel(rlCommandListHandle handle, const char* label);
RL_C_API rlResult rlListAppendBranchAbsCondPort(
    rlCommandListHandle handle, int32_t pos, uint32_t cond, rlIOPort port, bool compareAsMask, bool ifNotTrue, uint32_t mask);
RL_C_API rlResult rlListAppendBranchRelCondPort(
    rlCommandListHandle handle, int32_t pos, uint32_t cond, rlIOPort port, bool compareAsMask, bool ifNotTrue, uint32_t mask);
RL_C_API rlResult rlListAppendBranchToLabelCondPort(
    rlCommandListHandle handle, const char* label, uint32_t cond, rlIOPort port, bool compareAsMask, bool ifNotTrue, uint32_t mask);
RL_C_API rlResult rlListAppendBranchAbsCondFlag(rlCommandListHandle handle, int32_t pos, const char* variableName, bool ifNotTrue);
RL_C_API rlResult rlListAppendBranchRelCondFlag(rlCommandListHandle handle, int32_t pos, const char* variableName, bool ifNotTrue);
RL_C_API rlResult rlListAppendBranchToLabelCondFlag(rlCommandListHandle handle, const char* label, const char* variableName, bool ifNotTrue);

// No longer supported, use  rlListAppendCallList*() that offers the same functionality
// RL_C_API rlResult rlListAppendBranchToList( rlCommandListHandle handle, int32_t listID );
// RL_C_API rlResult rlListAppendBranchToListCond( rlCommandListHandle handle, int32_t listID, uint16_t condMask, rlIOPort port );
// RL_C_API rlResult rlListAppendBranchToListCondFlag( rlCommandListHandle handle, int32_t listID, rlBooleanVariableHandle variable );

RL_C_API rlResult rlListAppendBranchList(rlCommandListHandle handle, int32_t listID);
RL_C_API rlResult rlListAppendBranchListCondPort(
    rlCommandListHandle handle, int32_t listID, uint32_t cond, rlIOPort port, bool compareAsMask, bool ifNotTrue, uint32_t mask);
RL_C_API rlResult rlListAppendBranchListCondFlag(rlCommandListHandle handle, int32_t listID, const char* variableName, bool ifNotTrue);
RL_C_API rlResult rlListAppendCallList(rlCommandListHandle handle, int32_t listID);
RL_C_API rlResult rlListAppendCallListCondPort(
    rlCommandListHandle handle, int32_t listID, uint32_t cond, rlIOPort port, bool compareAsMask, bool ifNotTrue, uint32_t mask);
RL_C_API rlResult rlListAppendCallListCondFlag(rlCommandListHandle handle, int32_t listID, const char* variableName, bool ifNotTrue);

RL_C_API rlResult rlListAppendLoopStart(rlCommandListHandle handle, int32_t count);
RL_C_API rlResult rlListAppendLoopEnd(rlCommandListHandle handle);
RL_C_API rlResult rlListAppendLoopBreak(rlCommandListHandle handle);

RL_C_API rlResult rlListAppendSwitchPort(rlCommandListHandle handle, rlIOPort port, bool compareAsMask, uint32_t mask);
RL_C_API rlResult rlListAppendSwitchValue(rlCommandListHandle handle, const char* variableName);

// No longer supported, use  rlListAppendCaseCallListPort() that offers the same functionality
// RL_C_API rlResult rlListAppendCaseList( rlCommandListHandle handle, int32_t listID, uint16_t condMask );
RL_C_API rlResult rlListAppendCaseBranchListPort(rlCommandListHandle handle, int32_t listID, uint32_t cond);
RL_C_API rlResult rlListAppendCaseCallListPort(rlCommandListHandle handle, int32_t listID, uint32_t cond);

RL_C_API rlResult rlListAppendCaseAbsPort(rlCommandListHandle handle, int32_t pos, uint32_t cond);
RL_C_API rlResult rlListAppendCaseRelPort(rlCommandListHandle handle, int32_t pos, uint32_t cond);
RL_C_API rlResult rlListAppendCaseToLabelPort(rlCommandListHandle handle, const char* label, uint32_t cond);

// No longer supported, use  rlListAppendCaseCallListValue() that offers the same functionality
// RL_C_API rlResult rlListAppendCaseListValue( rlCommandListHandle handle, int32_t listID, int32_t value );
RL_C_API rlResult rlListAppendCaseBranchListValue(rlCommandListHandle handle, int32_t listID, int32_t value);
RL_C_API rlResult rlListAppendCaseCallListValue(rlCommandListHandle handle, int32_t listID, int32_t value);

RL_C_API rlResult rlListAppendCaseAbsValue(rlCommandListHandle handle, int32_t pos, int32_t value);
RL_C_API rlResult rlListAppendCaseRelValue(rlCommandListHandle handle, int32_t pos, int32_t value);
RL_C_API rlResult rlListAppendCaseToLabelValue(rlCommandListHandle handle, const char* label, int32_t value);

// No longer supported, use  rlListAppendDefaultCallList*() that offers the same functionality
// RL_C_API rlResult rlListAppendDefaultList( rlCommandListHandle handle, int32_t listID );
RL_C_API rlResult rlListAppendDefaultBranchList(rlCommandListHandle handle, int32_t listID);
RL_C_API rlResult rlListAppendDefaultCallList(rlCommandListHandle handle, int32_t listID);

RL_C_API rlResult rlListAppendDefaultAbs(rlCommandListHandle handle, int32_t pos);
RL_C_API rlResult rlListAppendDefaultRel(rlCommandListHandle handle, int32_t pos);
RL_C_API rlResult rlListAppendDefaultToLabel(rlCommandListHandle handle, const char* label);

RL_C_API rlResult rlListAppendExitList(rlCommandListHandle handle);
RL_C_API rlResult rlListAppendExitListCondPort(rlCommandListHandle handle, uint32_t cond, rlIOPort port, bool compareAsMask, bool ifNotTrue, uint32_t mask);
RL_C_API rlResult rlListAppendExitListCondFlag(rlCommandListHandle handle, const char* variableName, bool ifNotTrue);

RL_C_API rlResult rlListAppendBranchStandAloneList(rlCommandListHandle handle);

RL_C_API rlResult rlListAppendSelectFont(rlCommandListHandle handle, int32_t fontID);
RL_C_API rlResult rlListAppendMarkChar(rlCommandListHandle handle, char c);
RL_C_API rlResult rlListAppendMarkText(rlCommandListHandle handle, const char* text);
RL_C_API rlResult rlListAppendMarkTime(rlCommandListHandle handle);
RL_C_API rlResult rlListAppendMarkCounter(rlCommandListHandle handle, const char* counterName, int32_t len);

RL_C_API rlResult rlListAppendArcAbs2D(rlCommandListHandle handle, double x, double y, double sweep);
RL_C_API rlResult rlListAppendArcAbs3D(rlCommandListHandle handle, double x, double y, double z, double sweep);
RL_C_API rlResult rlListAppendArcRel2D(rlCommandListHandle handle, double x, double y, double sweep);
RL_C_API rlResult rlListAppendArcRel3D(rlCommandListHandle handle, double x, double y, double z, double sweep);

RL_C_API rlResult rlListAppendEllipseAbs2D(rlCommandListHandle handle, double x, double y, double sweep, double rotation, double ratio);
RL_C_API rlResult rlListAppendEllipseAbs3D(rlCommandListHandle handle, double x, double y, double z, double sweep, double rotation, double ratio);
RL_C_API rlResult rlListAppendEllipseRel2D(rlCommandListHandle handle, double x, double y, double sweep, double rotation, double ratio);
RL_C_API rlResult rlListAppendEllipseRel3D(rlCommandListHandle handle, double x, double y, double z, double sweep, double rotation, double ratio);

RL_C_API rlResult rlListAppendEllipticCurveAbs2D(rlCommandListHandle handle, double x, double y, double sweep, double rotation, double ratio);
RL_C_API rlResult rlListAppendEllipticCurveAbs3D(rlCommandListHandle handle, double x, double y, double z, double sweep, double rotation, double ratio);
RL_C_API rlResult rlListAppendEllipticCurveRel2D(rlCommandListHandle handle, double x, double y, double sweep, double rotation, double ratio);
RL_C_API rlResult rlListAppendEllipticCurveRel3D(rlCommandListHandle handle, double x, double y, double z, double sweep, double rotation, double ratio);

RL_C_API rlResult rlListAppendGeneralEllipse(
    rlCommandListHandle handle, double ux, double uy, double uz, double vx, double vy, double vz, double wx, double wy, double wz, double sweepTurns);

RL_C_API rlResult rlListAppendQuadraticBezierAbs2D(rlCommandListHandle handle, double targetX, double targetY, double controlX, double controlY);
RL_C_API rlResult rlListAppendQuadraticBezierAbs3D(
    rlCommandListHandle handle, double targetX, double targetY, double targetZ, double controlX, double controlY, double controlZ);
RL_C_API rlResult rlListAppendQuadraticBezierRel2D(rlCommandListHandle handle, double targetX, double targetY, double controlX, double controlY);
RL_C_API rlResult rlListAppendQuadraticBezierRel3D(
    rlCommandListHandle handle, double targetX, double targetY, double targetZ, double controlX, double controlY, double controlZ);
RL_C_API rlResult rlListAppendCubicBezierAbs2D(
    rlCommandListHandle handle, double targetX, double targetY, double control0X, double control0Y, double control1X, double control1Y);
RL_C_API rlResult rlListAppendCubicBezierAbs3D(rlCommandListHandle handle, double targetX, double targetY, double targetZ, double control0X, double control0Y,
    double control0Z, double control1X, double control1Y, double control1Z);
RL_C_API rlResult rlListAppendCubicBezierRel2D(
    rlCommandListHandle handle, double targetX, double targetY, double control0X, double control0Y, double control1X, double control1Y);
RL_C_API rlResult rlListAppendCubicBezierRel3D(rlCommandListHandle handle, double targetX, double targetY, double targetZ, double control0X, double control0Y,
    double control0Z, double control1X, double control1Y, double control1Z);

RL_C_API rlResult rlListAppendBitmapLineAbs2D(rlCommandListHandle handle, double start_x, double start_y, double end_x, double end_y, const uint16_t* values,
    int32_t valuesLength, rlPowerChannels powerTargetChannel);
RL_C_API rlResult rlListAppendBitmapLineRel2D(rlCommandListHandle handle, double start_x, double start_y, double end_x, double end_y, const uint16_t* values,
    int32_t valuesLength, rlPowerChannels powerTargetChannel);
RL_C_API rlResult rlListAppendBitmapLineAbs3D(rlCommandListHandle handle, double start_x, double start_y, double start_z, double end_x, double end_y,
    double end_z, const uint16_t* values, int32_t valuesLength, rlPowerChannels powerTargetChannel);
RL_C_API rlResult rlListAppendBitmapLineRel3D(rlCommandListHandle handle, double start_x, double start_y, double start_z, double end_x, double end_y,
    double end_z, const uint16_t* values, int32_t valuesLength, rlPowerChannels powerTargetChannel);

RL_C_API rlResult rlListAppendPointAndShootLineAbs2D(rlCommandListHandle handle, double start_x, double start_y, double end_x, double end_y,
    const double* exposureTimes, int32_t exposureTimesLength, const uint16_t* powerValues, int32_t powerValuesLength, rlPowerChannels powerTargetChannel);
RL_C_API rlResult rlListAppendPointAndShootLineRel2D(rlCommandListHandle handle, double start_x, double start_y, double end_x, double end_y,
    const double* exposureTimes, int32_t exposureTimesLength, const uint16_t* powerValues, int32_t powerValuesLength, rlPowerChannels powerTargetChannel);
RL_C_API rlResult rlListAppendPointAndShootLineAbs3D(rlCommandListHandle handle, double start_x, double start_y, double start_z, double end_x, double end_y,
    double end_z, const double* exposureTimes, int32_t exposureTimesLength, const uint16_t* powerValues, int32_t powerValuesLength,
    rlPowerChannels powerTargetChannel);
RL_C_API rlResult rlListAppendPointAndShootLineRel3D(rlCommandListHandle handle, double start_x, double start_y, double start_z, double end_x, double end_y,
    double end_z, const double* exposureTimes, int32_t exposureTimesLength, const uint16_t* powerValues, int32_t powerValuesLength,
    rlPowerChannels powerTargetChannel);

RL_C_API rlResult rlListAppendJumpAndShoot2D(
    rlCommandListHandle handle, const rlJumpAndShootItem2D* points, int32_t pointsLength, rlPowerChannels powerTargetChannel);
RL_C_API rlResult rlListAppendJumpAndShoot3D(
    rlCommandListHandle handle, const rlJumpAndShootItem3D* points, int32_t pointsLength, rlPowerChannels powerTargetChannel);

// This method is deprecated, please use AppendPositions instead.
RL_C_API rlResult rlListAppendMicroVectors2D(rlCommandListHandle handle, const rlPoint2DInt* bitPositions, uint32_t bitPositionsLength);
// This method is deprecated, please use AppendPositions instead.
RL_C_API rlResult rlListAppendMicroVectors3D(rlCommandListHandle handle, const rlPoint3DInt* bitPositions, uint32_t bitPositionsLength);

RL_C_API rlResult rlListAppendPositions2D(rlCommandListHandle handle, const rlPoint2D* bitPositions, uint32_t bitPositionsLength);
RL_C_API rlResult rlListAppendPositions3D(rlCommandListHandle handle, const rlPoint3D* bitPositions, uint32_t bitPositionsLength);

RL_C_API rlResult rlListAppendEnhancedCommand(rlCommandListHandle handle, int32_t head, rlAxis axis, uint32_t command);
RL_C_API rlResult rlListAppendGpioValue(rlCommandListHandle handle, rlIOPort port, rlPinAction mode, uint32_t value);
RL_C_API rlResult rlListAppendDacValue(rlCommandListHandle handle, rlPowerTarget dac, uint32_t value);
RL_C_API rlResult rlListAppendTraceConfig(rlCommandListHandle handle, const struct rltbTraceBufferConfig_Struct* config);
RL_C_API rlResult rlListAppendTraceLabel(rlCommandListHandle handle, int32_t value);
RL_C_API rlResult rlListAppendSpiWrite(rlCommandListHandle handle, int32_t module, uint32_t value);

RL_C_API rlResult rlListAppendHeadBias(rlCommandListHandle handle, int32_t head, rlAxes axes, const double* biases, uint32_t biasesLength);

RL_C_API rlResult rlListAppendSelectHeadCorrection(rlCommandListHandle handle, int32_t head, int32_t correction);

RL_C_API rlResult rlListAppendEnableWobble(rlCommandListHandle handle, bool enable);
RL_C_API rlResult rlListAppendWobbleAmplitude(rlCommandListHandle handle, const rlPoint2D* amplitude);
RL_C_API rlResult rlListAppendWobbleFrequency(rlCommandListHandle handle, const rlPoint2D* frequency);
RL_C_API rlResult rlListAppendWobblePhase(rlCommandListHandle handle, const rlPoint2D* phase);
RL_C_API rlResult rlListAppendWobbleCircle(rlCommandListHandle handle, double amplitude, double frequency);
RL_C_API rlResult rlListAppendWobbleEight(rlCommandListHandle handle, const rlPoint2D* amplitude, double baseFrequency);

RL_C_API rlResult rlListAppendSerialPortTransmitString(rlCommandListHandle handle, const char* transmitMessage);
RL_C_API rlResult rlListAppendSerialPortTransmitLine(rlCommandListHandle handle, const char* transmitMessage);
RL_C_API rlResult rlListAppendSerialPortTransmitBytes(rlCommandListHandle handle, const uint8_t* transmitMessage, uint32_t transmitMessageLength);
RL_C_API rlResult rlListAppendSerialPortVerifyResponseString(rlCommandListHandle handle, const char* transmitMessage, const char* goodResponse);
RL_C_API rlResult rlListAppendSerialPortVerifyResponseLine(rlCommandListHandle handle, const char* transmitMessage, const char* goodResponse);
RL_C_API rlResult rlListAppendSerialPortVerifyResponseBytes(
    rlCommandListHandle handle, const uint8_t* transmitMessage, uint32_t transmitMessageLength, const uint8_t* goodResponse, uint32_t goodResponseLength);

#endif // SPICE3_LIST_API_
